<!DOCTYPE html>
<html dir="rtl" class="uk-height-1-1">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title><?=lang('login')?></title>
		<link rel="icon" href="img/favicon.ico">
		<!-- CSS FILES -->
		<link rel="stylesheet" type="text/css" href="<?=base_url(sett('web_style_assets_dir'));?>/css/uikit-rtl.min.css">
	</head>
	<body class="uk-height-1-1">
		<div class="uk-flex uk-flex-center uk-flex-middle uk-background-muted uk-height-viewport">
			<div class="uk-position-bottom-center uk-position-small uk-visible@m">
				<span class="uk-text-small uk-text-muted">  <a href="<?=site_url()?>" ><?=lang('site.name')?></a> &copy; <?=date('Y')?>   - Powered by <a href="https://www.ttwir.com" target="_blank">Ttwir</a></span>
			</div>
			<div class="uk-width-medium uk-padding-small">
			<center><img style='max-width:150px; max-height:150px' src="<?=soft_image(stt("mktb_logo"),'logos/logo_sqr.png')?>"></center>
				<?php echo form_open(); ?>
					<fieldset class="uk-fieldset">
						<legend class="uk-legend"><?=lang('login')?></legend>
						<?php echo validation_errors(); ?>
									<?php if(count($errors)>0){
										foreach ($errors as $err){
											echo "<p style='color: red'> $err</p>";
										}
									}
									?>
						<div class="uk-margin">
							<div class="uk-inline uk-width-1-1">
								<span class="uk-form-icon uk-form-icon-flip" data-uk-icon="icon: user"></span>
								<input name="username" class="uk-input uk-form-large" required placeholder="<?=lang('user_name')?>" type="text">
							</div>
						</div>
						<div class="uk-margin">
							<div class="uk-inline uk-width-1-1">
								<span class="uk-form-icon uk-form-icon-flip" data-uk-icon="icon: lock"></span>
								<input  name="password" class="uk-input uk-form-large" required placeholder="<?=lang('password')?>" type="password">
							</div>
						</div>
						
						
						<div class="uk-margin uk-margin-small-bottom">
							<button type="submit" class="uk-button uk-button-primary uk-button-primary uk-button-large uk-width-1-1"><?=lang('login')?></button>
						</div>
					</fieldset>
				</form>
				<div>
					<div class="uk-text-center uk-margin-small">
					<?php if(stt('allow_public_browsing')): ?>
						<a class=" "  href="<?=site_url('front')?>"><?=lang('browse_without_login')?></a> |
					<?php endif ?>
						
						<a class=" "  href="<?=site_url()?>"><?=lang('welcome_page')?></a>
					</div>
					
						
					</div>
				</div>
			</div>
		</div>
		
		<!-- JS FILES -->
		<script src="<?=base_url(sett('web_style_assets_dir'));?>/js/uikit.min.js"></script>
		<script src="<?=base_url(sett('web_style_assets_dir'));?>/js/uikit-icons.min.js"></script>
	</body>
</html>
